'
' This program checks the BLASTER environment variable to determine the card
' settings and hence determine the features available.
'

' $INCLUDE: 'SBC.BI'


CONST MAXCARD = 3

DIM CardType$ (MAXCARD), wFeature%

CardType$ (0) = "Sound Blaster"
CardType$ (1) = "Sound Blaster Pro"
CardType$ (2) = "Sound Blaster 2.0"


IF (SBGETENV% = 0) THEN

    wFeature% = SBCHKCRD%

    IF (wFeature% <> 0) THEN

        IF SBTSTINT% THEN

            IF SBTSTDMA% >= 0 THEN
                PRINT CardType$(CARDID%-1);" card installed at :"
                PRINT TAB(5); "I/O address : "; HEX$ (IOADDX%); " Hex"
                PRINT TAB(5); "Interrupt   : "; INTNUM%
                PRINT TAB(5); "DMA Channel : "; DMACHL%
                PRINT

                IF (wFeature% AND 2) <> 0 THEN
                    PRINT "FM Music available."
                ENDIF

                IF (wFeature% AND 4) <> 0 THEN
                    PRINT "Creative Voice available."
                ENDIF
            ELSE
                PRINT "Error on DMA channel."
            ENDIF
        ELSE
            PRINT "Error on interrupt."
        ENDIF
    ELSE
        PRINT "Sound Blaster Card not found or wrong I/O setting"
    ENDIF
ELSE
    PRINT "BLASTER environment variable not set or incomplete or invalid."
ENDIF

END
